/* Wiktor Zychla, 2003 */
using System;
using System.Reflection;

namespace Example
{	  
  class CExample
  {  	
    static Assembly GetAssembly(string[] args)
    {
      Assembly assembly;
      if (0 == args.Length)
      {
          assembly = Assembly.GetExecutingAssembly();
      }
      else
      {
          assembly = Assembly.LoadFrom(args[0]);
      }
      return assembly;
    }

    public static void Main(string[] args)
    {
      Assembly assembly = GetAssembly(args);
      if (null != assembly)
      {
        Console.WriteLine("Informacje o typach dla {0}", assembly);

        Type[] types = assembly.GetTypes();
        foreach(Type type in types)
        {
          Console.WriteLine("\nTyp: {0}", type);
          foreach(MemberInfo member in type.GetMembers())
          {
            Console.WriteLine("\tSkladowa: {0}", member);
          }
        }
      }      
    }
  }
}
